/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: α׷ A/D CH0 CH1 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   Ϸ ϴ Դϴ.
/*      α׷ scan ۸  handlingϴ  ְ
/*     ֽϴ.
/*
/* - Remarks : 
/*     1.   COMI-ST101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMICX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasCX.h"

#define DEV_ID	COMI_ST101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		10240	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 1};  /* Scan channel list : 0  1 ä */
	FILE *fp;
	short *pScanBuf;
	ULONG c, prv_cnt, cur_cnt;
	UINT idx1, idx2;

	/* Load DLL */
	if(!COMICX_LoadDll()){
		printf("ComidasLX.dll load failure\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMICX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMICX_UnloadDll();
		exit(0);
	}

	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	// Ʒ COMICX_AD_SetInputType() Լ COMI-ST201//
	//  Ǵ ԼԴϴ. COMI-ST201带 ϴ//
	// 쿡 Ʒ Լ ּ Ͻʽÿ.            //
	// Analog Input type 'Single ended' Ѵ. //
	// Differential Է ϰ Ѵٸ AI_SINGLEſ  //
	// AI_DIFF  Ͽ Ѵ.                          //

	//COMICX_AD_SetInputType (hDevice, AI_SINGLE);
	
	/* start unlimited scan */
	long act_freq = COMICX_US1_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!\n");
		printf("%s", COMICX_ErrorString (COMICX_LastError())); 
		COMICX_UnloadDevice(hDevice);
		COMICX_UnloadDll();
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMICX_US1_Stop (hDevice, TRUE);
		COMICX_UnloadDevice(hDevice);
		COMICX_UnloadDll();
	}
	fprintf (fp,"   CH0    CH4\n");
	
	pScanBuf = COMICX_US1_GetBuffer(hDevice); // Get scan buffer pointer
	prv_cnt = 0; // initialize count variable
	
	while(!kbhit())
	{
		cur_cnt = COMICX_US1_CurCount (hDevice);
		
		/* prv_cnt   : end count of previously processed data block     */
		/* prv_cnt+1 : initial count of newly scaned data block         */
		/* cur_cnt   : end count of current newly scanned data block    */
		for(c = prv_cnt+1; c <= cur_cnt; c++)
		{
			/* COMICX_US1_SBPos (..) Լ ̿Ͽ  ä ۻ ε ´. */
			/* ̶ ι° Ķʹ äιȣ ƴ϶ ä Ʈ ̴.   */
			/* , CH0 0̰, CH4 1 ȴ.                                     */   
			idx1 = COMICX_US1_SBPos (hDevice, 0, c);
			idx2 = COMICX_US1_SBPos (hDevice, 1, c);

			/* File ͸ Ѵ. Ʒ ڵ Voltage ϴ */
			/*  ƴϰ 0~4095  ȴ.					  */
			fprintf (fp, "%6d %6d\n", pScanBuf[idx1], pScanBuf[idx2]);
		}
		printf("Saved scan count = %u\n", cur_cnt);
		prv_cnt = cur_cnt;
	}
	
	COMICX_US1_Stop (hDevice, TRUE);
	fclose(fp);

	COMICX_UnloadDevice(hDevice);
	COMICX_UnloadDll();
}
